<?php
// ---------------------------
// CORS & JSON headers
// ---------------------------
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['message' => 'Only POST requests are allowed']);
    exit;
}

// ---------------------------
// Get POST data
// ---------------------------
$input = json_decode(file_get_contents('php://input'), true);
if (empty($input['hsIds']) || !is_array($input['hsIds'])) {
    http_response_code(400);
    echo json_encode(['message' => 'hsIds array is required in request body']);
    exit;
}

if (empty($input['tableId'])) {
    http_response_code(400);
    echo json_encode(['message' => 'tableId is required in request body']);
    exit;
}

// ---------------------------
// Generate unique job ID and store data
// ---------------------------
$jobId = uniqid('pdf_job_', true);
$jobData = [
    'hsIds' => $input['hsIds'],
    'tableId' => $input['tableId'],
    'created_at' => time(),
    'status' => 'pending'
];

// Store job data in a temporary file
if (!is_dir('jobs')) mkdir('jobs', 0777, true);
file_put_contents("jobs/{$jobId}.json", json_encode($jobData));

// ---------------------------
// Start background process with nohup and capture PID
// ---------------------------
$scriptPath = __DIR__ . '/pdf_worker.php';
$command = "nohup php " . escapeshellarg($scriptPath) . " " . 
           escapeshellarg($jobId) . " > /dev/null 2>&1 & echo $!";
$pid = trim(shell_exec($command));

if (empty($pid)) {
    http_response_code(500);
    echo json_encode(['message' => 'Failed to start background process']);
    exit;
}

// Store PID with job data
$jobData['pid'] = $pid;
file_put_contents("jobs/{$jobId}.json", json_encode($jobData));

// ---------------------------
// Immediate response
// ---------------------------
echo json_encode([
    'message' => 'PDF generation started in background',
    'jobId' => $jobId,
    'pid' => $pid,
    'status' => 'processing'
]);
?>