<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['message' => 'Only GET requests are allowed']);
    exit;
}

if (empty($_GET['jobId'])) {
    http_response_code(400);
    echo json_encode(['message' => 'jobId is required']);
    exit;
}

$jobId = $_GET['jobId'];
$jobFile = "jobs/{$jobId}.json";

if (!file_exists($jobFile)) {
    http_response_code(404);
    echo json_encode(['message' => 'Job not found']);
    exit;
}

$jobData = json_decode(file_get_contents($jobFile), true);

// Check if process is still running if status is processing
if ($jobData['status'] === 'processing' && isset($jobData['pid'])) {
    $output = [];
    $returnCode = 0;
    exec("ps -p " . escapeshellarg($jobData['pid']) . " > /dev/null 2>&1", $output, $returnCode);
    
    // If process is not running but status is still processing, mark as error
    if ($returnCode !== 0) {
        $jobData['status'] = 'error';
        $jobData['error'] = 'Background process terminated unexpectedly';
        file_put_contents($jobFile, json_encode($jobData));
    }
}

echo json_encode($jobData);
?>