<?php
// ---------------------------
// Headers
// ---------------------------
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['message' => 'Only POST allowed']);
    exit;
}

// ---------------------------
// Input
// ---------------------------
$input = json_decode(file_get_contents('php://input'), true);

if (empty($input['hsId']) || empty($input['tableId'])) {
    http_response_code(400);
    echo json_encode(['message' => 'hsId and tableId are required']);
    exit;
}

$hsId    = $input['hsId'];
$tableId = $input['tableId'];

// ---------------------------
// Config
// ---------------------------
$authKey = 'pat-na1-62de1cbe-0ad2-46e2-b982-10c693e2eaf2';

// ---------------------------
// Includes
// ---------------------------
require('../tfpdf/tfpdf.php');
require_once 'category_wise_fields.php';

// ---------------------------
// Fetch HubDB Row
// ---------------------------
$url = "https://api.hubapi.com/cms/v3/hubdb/tables/{$tableId}/rows/{$hsId}";
$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $authKey",
        "Content-Type: application/json"
    ]
]);

$response = curl_exec($ch);
if (curl_errno($ch)) {
    http_response_code(500);
    echo json_encode(['message' => curl_error($ch)]);
    exit;
}
curl_close($ch);

$row = json_decode($response, true);
if (empty($row['values'])) {
    http_response_code(404);
    echo json_encode(['message' => 'HubDB row not found']);
    exit;
}

$values   = $row['values'];
$category = $values['category'] ?? '';
$raw      = !empty($values['raw']) ? json_decode($values['raw'], true) : [];

// ---------------------------
// PDF Title
// ---------------------------
$title =
    $values['devices_software_app_name']
    ?? $raw['company_name']
    ?? $raw['institution_name']
    ?? 'Submission';

// ---------------------------
// Create PDF
// ---------------------------
$pdf = new tFPDF();
$pdf->AddPage();

// Fonts
$pdf->AddFont('DejaVu','','DejaVuSans.ttf', true);
$pdf->AddFont('DejaVu','B','DejaVuSans-Bold.ttf', true);
$pdf->AddFont('DejaVu','I','DejaVuSans-Oblique.ttf', true);

$pdf->SetFont('DejaVu','B',14);
$pdf->Cell(0, 10, $title, 0, 1, 'C');
$pdf->Ln(5);

// ---------------------------
// Questions
// ---------------------------
$question_list = getQuestionList($category);

foreach ($question_list as $q) {
    $label    = $q['label'] ?? '';
    $subLabel = $q['sub-label'] ?? '';
    $name     = $q['name'] ?? '';
    $type     = $q['type'] ?? '';
    $value    = $raw[$name] ?? '';

    $pdf->SetFont('DejaVu','B',12);
    $pdf->MultiCell(0, 7, $label . ':');
    $pdf->Ln(1);

    if ($subLabel) {
        $pdf->SetFont('DejaVu','I',10);
        $pdf->MultiCell(0, 6, $subLabel);
        $pdf->Ln(1);
    }

    $pdf->SetFont('DejaVu','',11);

    // File links only (no download/store)
    if ($type === 'image' && $value && $value !== '|') {
        $files = explode('|', $value);
        foreach ($files as $file) {
            $file = trim($file);
            if ($file) {
                $link = "https://5486117.fs1.hubspotusercontent-na1.net/hubfs/5486117/Submission%20Files/{$hsId}/{$file}";
                $pdf->SetTextColor(0,0,255);
                $pdf->Write(6, $file, $link);
                $pdf->Ln(6);
                $pdf->SetTextColor(0,0,0);
            }
        }
    } else {
        $pdf->MultiCell(0, 6, $value ?: 'N/A');
    }

    $pdf->Ln(3);
}

// ---------------------------
// Direct Output (NO FILE SAVE)
// ---------------------------
header('Content-Type: application/pdf');
header('Content-Disposition: inline; filename="submission.pdf"');

$pdf->Output('I');
exit;
